﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using PsgBase;
using PsgIntl;

namespace Region
{
    [EditorClass, ViewGrid]
    public partial class Region : Base
    {
        #region Members
        RegionBE.RegionDataTable table = new RegionBE.RegionDataTable();
        RegionBE.RegionRow rowA = null;
        #endregion

        #region Constructors

        public Region()
        {
            InitializeComponent();
        }

        public Region(ViewGrid _browser)
            : base(_browser)
        {
            InitializeComponent();
        }

        public Region(LookupGrid _search)
            : base(_search)
        {
            InitializeComponent();
        }

        #endregion

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "regionid";
            context.PsgFieldDisplay = "regiondescription";
            context.PsgCommand = "region";
            context.PsgServerTableName = "region";
        }

        public override void PsgStart()
        {
            base.PsgStart();

            AddTable("region", ID, "C");
            GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "REGION":
                    table = (RegionBE.RegionDataTable)SetMainData(dt, table);
                    rowA = (RegionBE.RegionRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edRegion, table.regiondescriptionColumn);

            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.regiondescriptionColumn, GetIntl(Intl.Region), 200);

            this.FiltersView(table.regiondescriptionColumn, GetIntl(Intl.Region));
        }
    }
}
